{**
 * Packet.ai GPU Cloud — WHMCS Client Area Template
 *
 * Displays pod status, controls, quick-access links, and usage
 * statistics for a provisioned GPU pod.
 *
 * Available variables:
 *   {$pod}          — Pod data object from the Packet.ai API
 *   {$usage}        — Usage data for the current billing period
 *   {$serviceid}    — WHMCS service ID
 *   {$domain}       — Service domain
 *   {$serverdata}   — Server configuration array
 *   {$configoptions}— Product config options
 *   {$customfields} — Service custom fields
 *}

{if $pod}

{* ------------------------------------------------------------------ *}
{*  Pod Status Section                                                 *}
{* ------------------------------------------------------------------ *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-microchip"></i> GPU Pod Status
        </h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-sm-6">
                <table class="table table-condensed">
                    <tr>
                        <td><strong>Status</strong></td>
                        <td>
                            {if $pod->status == 'running' || $pod->status == 'active'}
                                <span class="label label-success">Running</span>
                            {elseif $pod->status == 'stopped'}
                                <span class="label label-default">Stopped</span>
                            {elseif $pod->status == 'suspended'}
                                <span class="label label-warning">Suspended</span>
                            {elseif $pod->status == 'provisioning'}
                                <span class="label label-info">Provisioning</span>
                            {elseif $pod->status == 'error'}
                                <span class="label label-danger">Error</span>
                            {else}
                                <span class="label label-default">{$pod->status|escape}</span>
                            {/if}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Pod ID</strong></td>
                        <td><code>{$pod->id|escape}</code></td>
                    </tr>
                    <tr>
                        <td><strong>GPU Type</strong></td>
                        <td>{$pod->gpu_type|escape|default:'N/A'}</td>
                    </tr>
                    {if $pod->ip_address}
                    <tr>
                        <td><strong>IP Address</strong></td>
                        <td><code>{$pod->ip_address|escape}</code></td>
                    </tr>
                    {/if}
                    {if $pod->created_at}
                    <tr>
                        <td><strong>Created</strong></td>
                        <td>{$pod->created_at|escape}</td>
                    </tr>
                    {/if}
                </table>
            </div>
            <div class="col-sm-6">

                {* -------------------------------------------------------------- *}
                {*  Control Buttons                                                *}
                {* -------------------------------------------------------------- *}

                <div class="well well-sm">
                    <h4 class="margin-bottom">Pod Controls</h4>

                    <form method="post" action="clientarea.php?action=productdetails&id={$serviceid}" class="form-inline">
                        <input type="hidden" name="id" value="{$serviceid}" />

                        {if $pod->status == 'stopped'}
                            <button type="submit" name="customAction" value="start" class="btn btn-success btn-sm">
                                <i class="fas fa-play"></i> Start
                            </button>
                        {/if}

                        {if $pod->status == 'running' || $pod->status == 'active'}
                            <button type="submit" name="customAction" value="stop" class="btn btn-warning btn-sm">
                                <i class="fas fa-stop"></i> Stop
                            </button>
                        {/if}

                        {if $pod->status == 'running' || $pod->status == 'active'}
                            <button type="submit" name="customAction" value="restart" class="btn btn-info btn-sm">
                                <i class="fas fa-sync"></i> Restart
                            </button>
                        {/if}

                        {if $pod->status == 'suspended'}
                            <p class="text-muted" style="margin-top: 8px;">
                                This pod is suspended. Please contact support or pay any
                                outstanding invoices to restore access.
                            </p>
                        {/if}

                        {if $pod->status == 'provisioning'}
                            <p class="text-muted" style="margin-top: 8px;">
                                <i class="fas fa-spinner fa-spin"></i>
                                Your pod is being provisioned. This usually takes a few minutes.
                            </p>
                        {/if}
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

{* ------------------------------------------------------------------ *}
{*  Quick Access Links                                                 *}
{* ------------------------------------------------------------------ *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-external-link-alt"></i> Quick Access
        </h3>
    </div>
    <div class="panel-body">
        <div class="row">
            {if $pod->status == 'running' || $pod->status == 'active'}
            <div class="col-sm-6">
                <a href="https://{$serverdata.hostname}/terminal/{$pod->id|escape:'url'}"
                   target="_blank"
                   class="btn btn-default btn-block" style="margin-bottom: 10px;">
                    <i class="fas fa-terminal"></i> Open SSH Terminal
                </a>
            </div>
            {/if}
            <div class="col-sm-6">
                <a href="https://{$serverdata.hostname}/dashboard"
                   target="_blank"
                   class="btn btn-default btn-block" style="margin-bottom: 10px;">
                    <i class="fas fa-tachometer-alt"></i> View in Dashboard
                </a>
            </div>
        </div>
    </div>
</div>

{* ------------------------------------------------------------------ *}
{*  Usage Statistics                                                   *}
{* ------------------------------------------------------------------ *}

{if $usage}
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-chart-bar"></i> Usage — Current Billing Period
        </h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped table-condensed">
            <thead>
                <tr>
                    <th>Metric</th>
                    <th>Value</th>
                </tr>
            </thead>
            <tbody>
                {if $usage.hours !== null}
                <tr>
                    <td>Compute Hours</td>
                    <td>{$usage.hours|string_format:"%.2f"} hrs</td>
                </tr>
                {/if}
                {if $usage.estimated_cost !== null}
                <tr>
                    <td>Estimated Cost</td>
                    <td>${$usage.estimated_cost|string_format:"%.2f"}</td>
                </tr>
                {/if}
                {if $usage.gpu_utilization !== null}
                <tr>
                    <td>Avg GPU Utilization</td>
                    <td>{$usage.gpu_utilization|string_format:"%.1f"}%</td>
                </tr>
                {/if}
                {if $usage.memory_utilization !== null}
                <tr>
                    <td>Avg Memory Utilization</td>
                    <td>{$usage.memory_utilization|string_format:"%.1f"}%</td>
                </tr>
                {/if}
            </tbody>
        </table>

        {if $usage.period_start && $usage.period_end}
        <p class="text-muted small">
            Period: {$usage.period_start|escape} &mdash; {$usage.period_end|escape}
        </p>
        {/if}
    </div>
</div>
{else}
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-chart-bar"></i> Usage — Current Billing Period
        </h3>
    </div>
    <div class="panel-body">
        <p class="text-muted">No usage data available for the current billing period.</p>
    </div>
</div>
{/if}

{else}

{* ------------------------------------------------------------------ *}
{*  Pod data unavailable                                               *}
{* ------------------------------------------------------------------ *}

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i>
    <strong>Pod information is unavailable.</strong>
    Your GPU pod may still be provisioning or the service has not yet been activated.
    If this persists, please <a href="submitticket.php">contact support</a>.
</div>

{/if}
