{**
 * Packet.ai GPU Cloud — WHMCS Admin Area Template
 *
 * Displays pod details, quick actions, and usage summary for
 * administrators viewing a Packet.ai service in the WHMCS admin panel.
 *
 * Available variables:
 *   {$pod}          — Pod data object from the Packet.ai API
 *   {$usage}        — Usage data for the current billing period
 *   {$serverdata}   — Server configuration array
 *}

{if $pod}

{* ------------------------------------------------------------------ *}
{*  Pod Details                                                        *}
{* ------------------------------------------------------------------ *}

<div class="row">
    <div class="col-md-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="glyphicon glyphicon-hdd"></i> Pod Details
                </h3>
            </div>
            <div class="panel-body">
                <table class="table table-condensed table-bordered">
                    <tr>
                        <td style="width: 180px;"><strong>Pod ID</strong></td>
                        <td><code>{$pod->id|escape}</code></td>
                    </tr>
                    <tr>
                        <td><strong>GPU Type</strong></td>
                        <td>
                            {if $pod->gpu_type == 'rtx-pro-6000'}
                                NVIDIA RTX PRO 6000 Blackwell
                            {elseif $pod->gpu_type == 'b200'}
                                NVIDIA B200
                            {elseif $pod->gpu_type == 'h200'}
                                NVIDIA H200
                            {elseif $pod->gpu_type == 'h100'}
                                NVIDIA H100
                            {else}
                                {$pod->gpu_type|escape|default:'Unknown'}
                            {/if}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Status</strong></td>
                        <td>
                            {if $pod->status == 'running' || $pod->status == 'active'}
                                <span class="label label-success">Running</span>
                            {elseif $pod->status == 'stopped'}
                                <span class="label label-default">Stopped</span>
                            {elseif $pod->status == 'suspended'}
                                <span class="label label-warning">Suspended</span>
                            {elseif $pod->status == 'provisioning'}
                                <span class="label label-info">Provisioning</span>
                            {elseif $pod->status == 'error'}
                                <span class="label label-danger">Error</span>
                            {else}
                                <span class="label label-default">{$pod->status|escape}</span>
                            {/if}
                        </td>
                    </tr>
                    {if $pod->ip_address}
                    <tr>
                        <td><strong>IP Address</strong></td>
                        <td><code>{$pod->ip_address|escape}</code></td>
                    </tr>
                    {/if}
                    {if $pod->created_at}
                    <tr>
                        <td><strong>Created</strong></td>
                        <td>{$pod->created_at|escape}</td>
                    </tr>
                    {/if}
                    {if $pod->region}
                    <tr>
                        <td><strong>Region</strong></td>
                        <td>{$pod->region|escape}</td>
                    </tr>
                    {/if}
                    {if $pod->image}
                    <tr>
                        <td><strong>Image</strong></td>
                        <td>{$pod->image|escape}</td>
                    </tr>
                    {/if}
                </table>
            </div>
        </div>
    </div>

    {* ------------------------------------------------------------------ *}
    {*  Quick Actions Sidebar                                              *}
    {* ------------------------------------------------------------------ *}

    <div class="col-md-4">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="glyphicon glyphicon-flash"></i> Quick Actions
                </h3>
            </div>
            <div class="panel-body">
                <a href="https://{$serverdata.hostname}/dashboard/pods/{$pod->id|escape:'url'}"
                   target="_blank"
                   class="btn btn-primary btn-block" style="margin-bottom: 8px;">
                    <i class="glyphicon glyphicon-dashboard"></i> View in Dashboard
                </a>

                {if $pod->status == 'running' || $pod->status == 'active'}
                <a href="https://{$serverdata.hostname}/terminal/{$pod->id|escape:'url'}"
                   target="_blank"
                   class="btn btn-default btn-block" style="margin-bottom: 8px;">
                    <i class="glyphicon glyphicon-console"></i> Open Terminal
                </a>
                {/if}

                <hr style="margin: 12px 0;" />

                <a href="https://{$serverdata.hostname}/admin"
                   target="_blank"
                   class="btn btn-info btn-block" style="margin-bottom: 8px;">
                    <i class="glyphicon glyphicon-cog"></i> Tenant Admin Dashboard
                </a>
            </div>
        </div>

        {* ------------------------------------------------------------------ *}
        {*  Pod Status Summary                                                 *}
        {* ------------------------------------------------------------------ *}

        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="glyphicon glyphicon-info-sign"></i> Status Summary
                </h3>
            </div>
            <div class="panel-body">
                {if $pod->status == 'running' || $pod->status == 'active'}
                    <div class="alert alert-success" style="margin-bottom: 0;">
                        <strong>Healthy.</strong> This pod is running normally.
                    </div>
                {elseif $pod->status == 'stopped'}
                    <div class="alert alert-warning" style="margin-bottom: 0;">
                        <strong>Stopped.</strong> The pod is not running. The customer
                        can start it from the client area.
                    </div>
                {elseif $pod->status == 'suspended'}
                    <div class="alert alert-danger" style="margin-bottom: 0;">
                        <strong>Suspended.</strong> The pod has been suspended
                        (likely due to non-payment). Unsuspend the service to restore access.
                    </div>
                {elseif $pod->status == 'provisioning'}
                    <div class="alert alert-info" style="margin-bottom: 0;">
                        <strong>Provisioning.</strong> The pod is being set up. This
                        usually takes a few minutes.
                    </div>
                {elseif $pod->status == 'error'}
                    <div class="alert alert-danger" style="margin-bottom: 0;">
                        <strong>Error.</strong> There is a problem with this pod.
                        Check the tenant dashboard for details or contact Packet.ai support.
                    </div>
                {else}
                    <div class="alert alert-info" style="margin-bottom: 0;">
                        Status: <strong>{$pod->status|escape}</strong>
                    </div>
                {/if}
            </div>
        </div>
    </div>
</div>

{* ------------------------------------------------------------------ *}
{*  Usage Summary for Current Billing Period                           *}
{* ------------------------------------------------------------------ *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="glyphicon glyphicon-stats"></i> Usage — Current Billing Period
        </h3>
    </div>

    {if $usage && ($usage.hours || $usage.estimated_cost)}
    <div class="panel-body">
        <div class="row">
            <div class="col-sm-3">
                <div class="well text-center" style="margin-bottom: 0;">
                    <h4 style="margin-top: 0; color: #333;">
                        {if $usage.hours !== null}
                            {$usage.hours|string_format:"%.2f"}
                        {else}
                            &mdash;
                        {/if}
                    </h4>
                    <small class="text-muted">Compute Hours</small>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="well text-center" style="margin-bottom: 0;">
                    <h4 style="margin-top: 0; color: #333;">
                        {if $usage.estimated_cost !== null}
                            ${$usage.estimated_cost|string_format:"%.2f"}
                        {else}
                            &mdash;
                        {/if}
                    </h4>
                    <small class="text-muted">Estimated Cost</small>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="well text-center" style="margin-bottom: 0;">
                    <h4 style="margin-top: 0; color: #333;">
                        {if $usage.gpu_utilization !== null}
                            {$usage.gpu_utilization|string_format:"%.1f"}%
                        {else}
                            &mdash;
                        {/if}
                    </h4>
                    <small class="text-muted">GPU Utilization</small>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="well text-center" style="margin-bottom: 0;">
                    <h4 style="margin-top: 0; color: #333;">
                        {if $usage.memory_utilization !== null}
                            {$usage.memory_utilization|string_format:"%.1f"}%
                        {else}
                            &mdash;
                        {/if}
                    </h4>
                    <small class="text-muted">Memory Utilization</small>
                </div>
            </div>
        </div>

        {if $usage.period_start && $usage.period_end}
        <p class="text-muted small" style="margin-top: 12px; margin-bottom: 0;">
            Period: {$usage.period_start|escape} &mdash; {$usage.period_end|escape}
        </p>
        {/if}
    </div>
    {else}
    <div class="panel-body">
        <p class="text-muted" style="margin-bottom: 0;">
            No usage data is available for the current billing period. Data is collected
            once daily by the WHMCS cron job.
        </p>
    </div>
    {/if}
</div>

{else}

{* ------------------------------------------------------------------ *}
{*  Pod data unavailable                                               *}
{* ------------------------------------------------------------------ *}

<div class="alert alert-warning">
    <i class="glyphicon glyphicon-warning-sign"></i>
    <strong>Pod information is unavailable.</strong>
    The GPU pod may still be provisioning, or the Pod ID custom field has not been set.
    Check the custom fields for this service to ensure a Pod ID is present.
</div>

{/if}
