# Packet.ai GPU Cloud — WHMCS Module

Provision and manage GPU pods directly from your WHMCS installation. This server module connects to the Packet.ai tenant API so your customers can order, manage, and be billed for GPU compute without leaving your hosting portal.

## What This Module Does

- **Automatic provisioning** — New GPU pods are created when an order is accepted.
- **Lifecycle management** — Suspend, unsuspend, and terminate pods from the WHMCS admin panel.
- **Upgrade / downgrade** — Change GPU types through the standard WHMCS upgrade flow.
- **Client area** — Customers see pod status, controls (start / stop / restart), SSH terminal access, and usage statistics.
- **Admin view** — Admins see pod details, quick-action links, and a usage summary.
- **Usage-based billing** — A daily cron job collects compute hours and cost data from the API.

### Supported GPU Types

| ID               | GPU                              |
|------------------|----------------------------------|
| `rtx-pro-6000`   | NVIDIA RTX PRO 6000 Blackwell   |
| `b200`           | NVIDIA B200                      |
| `h200`           | NVIDIA H200                      |
| `h100`           | NVIDIA H100                      |

---

## Requirements

- WHMCS **8.x** or later
- PHP **7.4+** (8.x recommended)
- PHP **cURL extension** enabled
- A **Packet.ai tenant account** with an API key (contact your Packet.ai account manager or visit your tenant admin dashboard to generate one)

---

## Installation

### 1. Copy the Module Files

Upload the `modules/servers/packetai/` directory into your WHMCS installation so the file structure looks like this:

```
<whmcs-root>/
  modules/
    servers/
      packetai/
        lib/
          PacketaiApi.php
        templates/
          admin.tpl
          clientarea.tpl
        hooks.php
        packetai.php
```

You can upload via SFTP, SCP, or your hosting control panel's file manager.

### 2. Set File Permissions

Make sure all files are readable by the web server. Standard permissions:

```
directories: 755
files:       644
```

### 3. Add the Server in WHMCS

1. Log in to your WHMCS admin panel.
2. Go to **Setup > Products/Services > Servers**.
3. Click **Add New Server**.
4. Fill in the details:

| Field            | Value                                                        |
|------------------|--------------------------------------------------------------|
| Name             | Any friendly name (e.g. "Packet.ai GPU Cloud")              |
| Hostname         | Your tenant dashboard URL (e.g. `gpu.yourbrand.com`)        |
| Type             | Select **Packet.ai GPU Cloud** from the dropdown            |
| Access Hash      | Paste your Packet.ai **API key**                             |

Leave the username and password fields blank — authentication uses the API key in the Access Hash field.

### 4. Test the Connection

Click **Test Connection** on the server configuration page. You should see a green "Successful!" message. If it fails, double-check:

- The hostname is correct and reachable from your WHMCS server.
- The API key is valid and has not expired.
- Your server can make outbound HTTPS requests (port 443).

---

## Product Configuration

### 1. Create a New Product

1. Go to **Setup > Products/Services > Products/Services**.
2. Create a new product (or edit an existing one).
3. On the **Module Settings** tab, select **Packet.ai GPU Cloud** as the module.
4. Select the server you added in the previous step.

### 2. Configure the GPU Type

Under the module settings you will see:

| Option          | Description                                                      |
|-----------------|------------------------------------------------------------------|
| **GPU Type**    | Select the GPU model customers will receive (`rtx-pro-6000`, `b200`, `h200`, or `h100`). |
| **SSH Public Key** | Optional default SSH key injected into every pod created with this product. Customers can also add their own keys from the dashboard. |

### 3. Add the Pod ID Custom Field

The module stores the provisioned pod's identifier in a custom field called **Pod ID**. WHMCS creates this automatically on first provision, but you can also create it manually:

1. On the product page, go to the **Custom Fields** tab.
2. Add a field:
   - **Field Name:** `Pod ID`
   - **Field Type:** Text Box
   - **Admin Only:** Yes (customers should not edit this)

### 4. Set Pricing

Configure pricing on the **Pricing** tab as you normally would. Common approaches:

- **Flat monthly fee** — Simple fixed price per GPU type.
- **Usage-based billing** — Combine a base fee with overage charges using the usage data the module collects (see Usage-Based Billing below).

### 5. Create Multiple Products for Different GPUs

To offer several GPU types, create one product per GPU type. Each product selects a different GPU Type in the module settings and has its own pricing.

---

## Client Area Features

When a customer views their GPU service in the WHMCS client area, they see:

- **Pod status** — Running, stopped, suspended, provisioning, or error.
- **Pod details** — Pod ID, GPU type, IP address, creation date.
- **Controls** — Start, stop, and restart buttons (shown based on current status).
- **Quick access links** — Open SSH terminal in the browser, view the pod in the dashboard.
- **Usage statistics** — Compute hours, estimated cost, GPU utilization, and memory utilization for the current billing period.

If the pod is suspended, customers see a message to contact support or pay outstanding invoices.

---

## Admin Area Features

When an administrator views a Packet.ai service in the WHMCS admin panel, they see:

- **Pod details** — Pod ID, full GPU name, status, IP, creation date, region, and image.
- **Quick actions** — Links to view the pod in the dashboard, open a terminal session, or access the tenant admin panel.
- **Status summary** — A quick health check explaining the current pod state.
- **Usage summary** — Compute hours, estimated cost, and utilization metrics displayed as summary cards.

---

## Usage-Based Billing

The module includes a `DailyCronJob` hook that runs automatically as part of the standard WHMCS daily cron. It:

1. Queries all active Packet.ai services.
2. Calls the Packet.ai API to fetch usage data since the start of the current month.
3. Stores the data (compute hours, estimated cost, GPU/memory utilization) in each service's `overagedata` field.

### How It Works

- The daily cron (`/path/to/whmcs/crons/cron.php`) must be scheduled in your server's crontab. This is standard WHMCS setup — no extra cron entry is needed for the Packet.ai module.
- Usage data is collected per pod and matched to services via the Pod ID custom field.
- The collected data is available in the admin area and can be used with WHMCS overage billing or custom invoice hooks.

### Verifying the Cron

Check the WHMCS **Utilities > Logs > Activity Log** for entries starting with `Packet.ai:`. After the daily cron runs, you should see:

```
Packet.ai: Daily usage collection completed successfully.
```

If there are errors, they will also appear in the activity log with the service ID and error message.

---

## Troubleshooting

### "Server hostname is not configured" or "API key is not configured"

The server record is missing the hostname or access hash. Go to **Setup > Products/Services > Servers**, edit the Packet.ai server, and make sure both fields are filled in.

### "Test Connection" fails

- Verify the hostname is your tenant dashboard URL without a trailing slash.
- Confirm the API key is correct. You can regenerate it from your tenant admin dashboard.
- Check that your WHMCS server can reach the hostname over HTTPS. Run `curl -I https://your-hostname.com/api/widget/config` from the server command line to test.
- If you are behind a firewall, ensure outbound port 443 is open.

### "No Pod ID found for this service"

The service does not have a Pod ID stored. This usually means:

- The pod was never provisioned (the Create Account action failed or was never run).
- The Pod ID custom field does not exist on the product. Add it manually (see Product Configuration above).

Try running **Module Commands > Create** from the service page in the admin panel to re-provision.

### Pod shows as "Provisioning" for a long time

Provisioning typically completes within a few minutes. If the status is stuck:

1. Check the Packet.ai tenant dashboard to see the pod's actual status.
2. Look at the WHMCS Activity Log for any API errors.
3. If the pod failed on the Packet.ai side, terminate and re-create the service.

### Usage data is not appearing

- Confirm the WHMCS daily cron is running. Check **Utilities > System > Automation Status**.
- Verify the Pod ID custom field is populated for the service.
- Check the Activity Log for `Packet.ai: Usage collection failed` messages.
- The usage API returns data for the current month. If the service was just created, data will appear after the first full cron run.

### Module not appearing in the server type dropdown

- Double-check the file path: the `packetai.php` file must be located at `modules/servers/packetai/packetai.php` relative to your WHMCS root.
- Clear the WHMCS template cache: **Utilities > System > Template Cache > Rebuild**.
- Verify file permissions (see Installation above).

---

## Module File Reference

```
modules/servers/packetai/
  packetai.php              Main provisioning module (create, suspend, unsuspend, terminate, upgrade)
  hooks.php                 Client area renderer, daily usage collection, activity logging
  lib/
    PacketaiApi.php         REST API client for the Packet.ai tenant API
  templates/
    admin.tpl               Admin panel service view (Smarty/Bootstrap 3)
    clientarea.tpl          Customer service view (Smarty/Bootstrap 3)
```

---

## Support

- **Module issues** — Contact your Packet.ai account manager or email support at your tenant's configured support address.
- **Packet.ai platform** — Visit [packet.ai](https://packet.ai) or reach out to the Packet.ai team. All customers receive 24/7 support.
- **WHMCS general help** — Refer to the [WHMCS documentation](https://docs.whmcs.com/) for questions about product setup, billing, and cron configuration.
